<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<%@ include file="printerFriendlyUnresolvedOpen.jspf"%>
<!-- %@ include file="printerFriendlyOpen.jspf"%-->
<%@ include file="pastDueMessage.jsp" %>

<h2><netui:content value="${pageFlow.extractName}"/> </h2>
<p>
The following is a list of your Wellness Reminders.
</p>

   <display:table id="${pageFlow.tableUID}" 
	        uid="${pageFlow.tableUID}" 
		    name="${pageFlow.wellnessReminders}">
    	<display:setProperty name="basic.msg.empty_list"
	    	value="There are currently no Wellness Reminders available" />            
   	    <display:column title="" 
   	        style="padding: 3px 3px 4px 3px">
   	    	<c:choose>
	        <c:when test="${WellnessReminder.showSymbol}">
        	   <img src="<%=request.getContextPath()%>/resources/images/icon_error-critical.gif"
    	    	    title="" height="15" width="15" />
			</c:when>
			<c:otherwise>
			  &nbsp;
			</c:otherwise>
			</c:choose>
        </display:column>            
		<display:column property="dueDate" title="Due Date"/>
		<display:column property="subject" title="Wellness Reminder"/>
		<display:column property="dateLastDone" title="Last Completed"/>    
		<display:column property="location" title="Location"/>
  </display:table>	
<%@ include file="goldStandardText.jspf"%>
<br/>
<%@ include file="../../common/printerFriendlyClose.jspf" %>